<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

try {
    // Test database connection
    $stmt = $db->query("SELECT 1 as test");
    $result = $stmt->fetch();
    
    if ($result) {
        echo "Database connection successful!\n";
        
        // Check if categories table exists
        $stmt = $db->query("SHOW TABLES LIKE 'categories'");
        if ($stmt->fetch()) {
            echo "Categories table exists.\n";
            
            // Check if we have any categories
            $stmt = $db->query("SELECT COUNT(*) as count FROM categories");
            $row = $stmt->fetch();
            echo "Number of categories: " . $row['count'] . "\n";
        } else {
            echo "Categories table does not exist.\n";
        }
        
        // Check if posts table exists
        $stmt = $db->query("SHOW TABLES LIKE 'posts'");
        if ($stmt->fetch()) {
            echo "Posts table exists.\n";
            
            // Check if we have any posts
            $stmt = $db->query("SELECT COUNT(*) as count FROM posts");
            $row = $stmt->fetch();
            echo "Number of posts: " . $row['count'] . "\n";
        } else {
            echo "Posts table does not exist.\n";
        }
    } else {
        echo "Database connection failed.\n";
    }
} catch (Exception $e) {
    echo "Database error: " . $e->getMessage() . "\n";
}
?>